# VoterMaster – ভোটার ব্যবস্থাপনা সিস্টেম

একটি Laravel 10+ (PHP 8.1+) অ্যাডমিন অ্যাপ যা বাংলা ভোটার তালিকা পিডিএফ থেকে ডাটা তুলে এনে অনুসন্ধান, প্রিন্ট ও এক্সপোর্ট করতে পারে।

## প্রয়োজনীয়তা
- PHP 8.1+
- MySQL/MariaDB (ডিবি: `VoterMaster`, ইউজার: `root`, পাসওয়ার্ড ফাঁকা)
- Composer

## সেটআপ
1. ডিপেনডেন্সি ইন্সটল: `composer install`
2. `.env` প্রস্তুত: `.env` বিদ্যমান, দরকার হলে DB তথ্য ঠিক করুন।
3. অ্যাপ কী: `php artisan key:generate`
4. স্টোরেজ লিংক: `php artisan storage:link`
5. মাইগ্রেশন + সিড: `php artisan migrate --seed`
   - ডিফল্ট অ্যাডমিন: **admin@votermaster.test / password**

## ব্যবহার প্রবাহ
1. লগইন: `/login`
2. ড্যাশবোর্ড: মূল পরিসংখ্যান ও সাম্প্রতিক আপলোড।
3. এলাকা ব্যবস্থাপনা: `/admin/areas` থেকে এলাকা CRUD।
4. পিডিএফ আপলোড: `/admin/source-files/upload`
   - বিদ্যমান এলাকা নির্বাচন করুন বা ফর্মের নিচে নতুন এলাকা তথ্য দিয়ে তৈরি করুন।
   - শুধুমাত্র PDF (max 20MB)। আপলোডের পরই পার্স/ইম্পোর্ট চলবে।
5. ভোটার তালিকা ও ফিল্টার: `/admin/voters`
   - ফিল্টার: সার্চ (নাম/নং/ঠিকানা), এলাকা, ওয়ার্ড/এরিয়া কোড, পেশা, বয়স সীমা, লিঙ্গ, সোর্স ফাইল।
   - টেবিলের বাম পাশে সিলেক্ট বক্স আছে।
   - অ্যাকশন: প্রিন্ট ভিউ, PDF এক্সপোর্ট, CSV এক্সপোর্ট।
6. একক ভোটার ভিউ: ভোটার রো থেকে “বিস্তারিত” → প্রিন্ট বাটনসহ কার্ড ভিউ।

## পিডিএফ পার্সিং (VoterPdfImportService)
- লাইব্রেরি: `smalot/pdfparser` (pure PHP, শেয়ার্ড হোস্টে চলে)।
- বাংলা ডিজিটকে ইংরেজিতে কনভার্ট করে `voter_no` ও `date_of_birth` সংরক্ষণ।
- ফিল্ড প্যাটার্ন: `নাম`, `ভোটার নং`, `পিতা`, `মাতা`, `পেশা`, `জন/জন্ম তারিখ`, `ঠিকানা`।
- ফলাফল সারাংশ: মোট ব্লক, সফল/ব্যর্থ কাউন্ট, ব্যর্থ ব্লক টেক্সট (ডিবাগ)।

## লাইসেন্স গার্ড
- `.env` কী:
  - `VM_LICENSE_DOMAIN=localhost`
  - `VM_LICENSE_KEY=hash_hmac('sha256', VM_LICENSE_DOMAIN, 'VoterMasterSecretSalt')`
    - লোকালহোস্টের জন্য তৈরি কী: `badc23dbbe37116be429547aed763eb6a2a6978a13ceeff87787a65822271c30`
- সব `/admin/*` রুটে `CheckVoterMasterLicense` মিডলওয়্যার প্রযোজ্য; মismatch হলে বাংলা এরর দেখায়।

## ডিপ্লয় নোট
- কিউ, রেডিস বা ডকার ব্যবহৃত নয়; শুধুই PHP-FPM + Artisan কমান্ড।
- আপলোড ফাইল `storage/app/voter_pdfs/` এ রাখা হয় (public এ নয়)।
- সেশন ও ক্যাশ ডাটাবেসে; CSRF ডিফল্ট সক্রিয়।

## দরকারী কমান্ড
- রিফ্রেশ + সিড: `php artisan migrate:fresh --seed`
- রুট লিস্ট: `php artisan route:list`
## OCR / Poppler / Tesseract setup
- Poppler (release-25.12.0-0) unzip to `tools/poppler/poppler-25.12.0/`; set `VM_PDFTOTEXT_PATH` and `VM_PDFTOPPM_PATH` accordingly.
- Tesseract v5.4.0 install to `C:\Program Files\Tesseract-OCR`; copy `ben.traineddata` into `tools/tessdata` (env `VM_TESSDATA_DIR`).
- Key .env flags: `VM_USE_PDFTOTEXT=true`, `VM_USE_OCR=true`, `VM_PDFTOTEXT_PATH`, `VM_PDFTOPPM_PATH`, `VM_TESSERACT_PATH`, `VM_TESSDATA_DIR`.
- Refresh cached text (`storage/app/ocr/full.txt`) after changing engines, then re-run the import.
- Re-import via tinker: `app(App\Services\VoterPdfImportService::class)->import(App\Models\SourceFile::find(2));`.
